---
generated_at: 2026-02-04 10:10:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：53-フォームレイアウト（Tailwind 2）

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  - なし。全主張にソースコード根拠あり。

## 2) 参照した情報（Evidence一覧）

- E-01: `src/Symfony/Bridge/Twig/Resources/views/Form/tailwind_2_layout.html.twig`（テンプレートソースコード、70行）
- E-02: `src/Symfony/Bridge/Twig/Resources/views/Form/form_div_layout.html.twig`（use元テーマソースコード、482行）
- E-03: `docs/code-to-docs/画面一覧/画面一覧.csv`（画面一覧）
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`（機能マッピング）

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | `{% use 'form_div_layout.html.twig' %}`でトレイト的インポートを使用 | E-01 行1 | ○ |
| C-02 | form_rowでrow_class変数（デフォルト`mb-6`）を使用 | E-01 行4 `row_class\|default('mb-6')` | ○ |
| C-03 | widget_attributesでwidget_class変数（デフォルト`mt-1 w-full`）を使用 | E-01 行9 `widget_class\|default('mt-1 w-full')` | ○ |
| C-04 | disabled時にwidget_disabled_class（デフォルト`border-gray-300 text-gray-500`）を追加 | E-01 行9 `widget_disabled_class\|default('border-gray-300 text-gray-500')` | ○ |
| C-05 | errors時にwidget_errors_class（デフォルト`border-red-700`）を追加 | E-01 行9 `widget_errors_class\|default('border-red-700')` | ○ |
| C-06 | form_labelでlabel_class変数（デフォルト`block text-gray-800`）を使用 | E-01 行14 `label_class\|default('block text-gray-800')` | ○ |
| C-07 | form_helpでhelp_class変数（デフォルト`mt-1 text-gray-600`）を使用 | E-01 行19 `help_class\|default('mt-1 text-gray-600')` | ○ |
| C-08 | form_errorsでerror_item_class変数（デフォルト`text-red-700`）を使用 | E-01 行27 `error_item_class\|default('text-red-700')` | ○ |
| C-09 | エラーメッセージがul/liリスト形式で表示される | E-01 行25-30 `<ul>...<li class=...>` | ○ |
| C-10 | choice_widget_expandedでmt-2クラスのdivを使用 | E-01 行34 `attr.class\|default('mt-2')` | ○ |
| C-11 | 各選択肢をflex items-centerでラップ | E-01 行37 `<div class="flex items-center">` | ○ |
| C-12 | checkbox_rowでinline-flex items-centerを使用 | E-01 行53 `<div class="inline-flex items-center">` | ○ |
| C-13 | checkbox_widgetのwidget_classデフォルトがmr-2 | E-01 行62 `widget_class\|default('mr-2')` | ○ |
| C-14 | radio_widgetのwidget_classデフォルトがmr-2 | E-01 行67 `widget_class\|default('mr-2')` | ○ |
| C-15 | 関連機能としてForm（No.34）とTwig Bridge（No.36）が主機能 | E-04 行132-133 | ○ |
| C-16 | checkbox_rowでaria-describedbyをヘルプテキスト用に設定 | E-01 行49 `'aria-describedby': id ~ '_help'` | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全主張がソースコードから確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] カスタマイズ変数のデフォルト値が正確に記載されているか確認
- [ ] `{% use %}`と`{% extends %}`の違いの説明が正確か確認
- [ ] Tailwind CSSユーティリティクラスの適用範囲が網羅されているか確認
